/**
 * Copyright (c) 2014 CoderKiss
 * <p/>
 * CoderKiss[AT]gmail.com
 */

package com.cqyh.cqadsdkdemo;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.ActivityManager;
import android.app.AlarmManager;
import android.app.Application;
import android.app.KeyguardManager;
import android.app.PendingIntent;
import android.app.admin.DevicePolicyManager;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.content.res.Resources;
import android.os.Build;
import android.os.Build.VERSION_CODES;
import android.os.Handler;
import android.os.Looper;
import android.os.PowerManager;
import android.os.Process;
import android.text.TextUtils;
import android.view.MotionEvent;
import android.view.View;

import androidx.annotation.DrawableRes;

import java.lang.reflect.Method;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 系统工具
 */
public class SystemUtil {

    //获取App版本号
    public static int getAppVersionCode(Context context) {
        int versionCode = -1;
        try {
            PackageManager pm = context.getPackageManager();
            PackageInfo pi = pm.getPackageInfo(
                    context.getPackageName(), 0);
            versionCode = pi.versionCode;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return versionCode;
    }

    //获取App版本名称
    public static String getAppVersionName(Context context) {
        String versionName = "";
        try {
            PackageManager pm = context.getPackageManager();
            PackageInfo pi = pm.getPackageInfo(
                    context.getPackageName(), 0);
            versionName = pi.versionName;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return versionName;
    }

    public static int getStatusBarHeight(Context context) {
        int height = 0;
        if (context == null) {
            return height;
        }
        Resources resources = context.getResources();
        int resId = resources.getIdentifier("status_bar_height", "dimen", "android");
        if (resId > 0) {
            height = resources.getDimensionPixelSize(resId);
        }
        return height;
    }

    /**
     * 获取已安装的app
     */
    public static List<String> getAllPackageName(Context context) {
        List<String> pkgNames = new ArrayList<>();
        List<ApplicationInfo> apps = SystemUtil.getInstalledApplications(context.getPackageManager());
        for (ApplicationInfo app : apps) {
            pkgNames.add(app.className);
        }
        return pkgNames;
    }

    public static List<String> getAllCustomPackageName(Context context) {
        List<String> pkgNames = new ArrayList<>();
        List<ApplicationInfo> apps = SystemUtil.getInstalledApplications(context.getPackageManager());
        for (ApplicationInfo app : apps) {
            if ((app.flags & ApplicationInfo.FLAG_SYSTEM) == 0 && !TextUtils.isEmpty(app.packageName)) {
                pkgNames.add(app.packageName);
            }
        }
        return pkgNames;
    }


    public static boolean isAppInstalled(Context context, String packageName) {
        PackageInfo packageInfo = null;
        if (TextUtils.isEmpty(packageName)) {
            return false;
        }
        final PackageManager packageManager = context.getPackageManager();
        List<PackageInfo> packageInfos = packageManager.getInstalledPackages(0);
        if (packageInfos == null) {
            return false;
        }
        for (int index = 0; index < packageInfos.size(); index++) {
            packageInfo = packageInfos.get(index);
            final String name = packageInfo.packageName;
            if (packageName.equals(name)) {
                return true;
            }
        }
        return false;
    }

    /**
     * 锁屏
     */
    public static void lockScreen(Context context) {
        DevicePolicyManager deviceManager = (DevicePolicyManager) context.getSystemService(Context.DEVICE_POLICY_SERVICE);
        deviceManager.lockNow();
    }

    public static int getDistance(MotionEvent e1, MotionEvent e2) {
        float x = e1.getX() - e2.getX();
        float y = e1.getY() - e2.getY();
        return (int) Math.sqrt(x * x + y * y);
    }

    public static long getMaxMemory(Context context) {
        Runtime runtime = Runtime.getRuntime();
        long maxMemory = runtime.maxMemory();
        //Log.d(TAG, "application max memory " + maxMemory);
        return maxMemory;
    }

    public static void restartApplication(Context context, Class<?> clazz) {
        Intent intent = new Intent(context, clazz);
        int pendingIntentId = 198964;
        PendingIntent pendingIntent = PendingIntent.getActivity(context,
                pendingIntentId, intent, PendingIntent.FLAG_CANCEL_CURRENT);
        AlarmManager am = (AlarmManager) context
                .getSystemService(Context.ALARM_SERVICE);
        am.set(AlarmManager.RTC, System.currentTimeMillis() + 500,
                pendingIntent);
        System.exit(0);
    }

    public static void killApplication(Context context, String packageName) {
        try {
            ActivityManager activityManager = (ActivityManager) context
                    .getSystemService(Context.ACTIVITY_SERVICE);
            activityManager.killBackgroundProcesses(packageName);
            Method forceStopPackage = activityManager.getClass()
                    .getDeclaredMethod("forceStopPackage", String.class);
            forceStopPackage.setAccessible(true);
            forceStopPackage.invoke(activityManager, packageName);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean isMainThread() {
        return Looper.getMainLooper() == Looper.myLooper();
    }

    public static void runOnMain(Runnable runnable) {
        if (runnable == null) {
            return;
        }

        if (isMainThread()) {
            runnable.run();
        } else {
            Handler handler = new Handler(Looper.getMainLooper());
            handler.post(runnable);
        }
    }

    public static void runOnMain(Runnable runnable, long delay) {
        if (runnable == null) {
            return;
        }
        Handler handler = new Handler(Looper.getMainLooper());
        handler.postDelayed(runnable, delay);
    }

    @TargetApi(VERSION_CODES.KITKAT)
    public static void hideSystemUI(Activity activity) {
        View decorView = activity.getWindow().getDecorView();
        decorView.setSystemUiVisibility(View.SYSTEM_UI_FLAG_LAYOUT_STABLE
                | View.SYSTEM_UI_FLAG_LAYOUT_HIDE_NAVIGATION
                | View.SYSTEM_UI_FLAG_LAYOUT_FULLSCREEN
                | View.SYSTEM_UI_FLAG_HIDE_NAVIGATION
                | View.SYSTEM_UI_FLAG_LOW_PROFILE
                | View.SYSTEM_UI_FLAG_FULLSCREEN
                | View.SYSTEM_UI_FLAG_IMMERSIVE);
    }

    @TargetApi(VERSION_CODES.KITKAT)
    public static void showSystemUI(Activity activity) {
        View decorView = activity.getWindow().getDecorView();
        decorView.setSystemUiVisibility(View.SYSTEM_UI_FLAG_LAYOUT_STABLE
                | View.SYSTEM_UI_FLAG_LAYOUT_HIDE_NAVIGATION
                | View.SYSTEM_UI_FLAG_LAYOUT_FULLSCREEN);
    }

    /**
     * 创建快捷方式
     */
    public static void createShortcut(Context context, String shortcutName, @DrawableRes int logoResId, Intent shortCutIntent) {
        Intent intent = new Intent("com.android.launcher.action.INSTALL_SHORTCUT");
        intent.putExtra(Intent.EXTRA_SHORTCUT_NAME, shortcutName);
        intent.putExtra("duplicate", false);
        intent.putExtra(Intent.EXTRA_SHORTCUT_INTENT, shortCutIntent);
        intent.putExtra(Intent.EXTRA_SHORTCUT_ICON_RESOURCE, Intent.ShortcutIconResource.fromContext(context, logoResId));
        context.sendBroadcast(intent);
    }

    public static boolean inKeyguardRestrictedInputMode(Context context) {
        KeyguardManager keyguardManager = (KeyguardManager) context.getSystemService(Context.KEYGUARD_SERVICE);
        return keyguardManager.inKeyguardRestrictedInputMode();
    }

    public static boolean isInteractive(Context context) {
        PowerManager pm = (PowerManager) context.getSystemService(Context.POWER_SERVICE);
        if (Build.VERSION.SDK_INT >= VERSION_CODES.KITKAT_WATCH) {
            return pm.isInteractive();
        } else {
            return pm.isScreenOn();
        }
    }

    /**
     * 各种有问题的手机 关闭硬件加速
     */
    private static final String DEVICE_NAME_M040 = "M040";
    private static final String DEVICE_NAME_M1 = "m1";
    private static final String DEVICE_NAME_NOTE = "HM NOTE 1LTE";

    public static void checkHardAccelerate(View view) {
        String name = "";
        /**
         * 魅族手机 关闭硬件加速 否则会出现车轮闪现的行为
         */
        if (DEVICE_NAME_M040.equals(name) || DEVICE_NAME_M1.equals(name) ||
                DEVICE_NAME_NOTE.equals(name)) {
            view.setLayerType(View.LAYER_TYPE_SOFTWARE, null);
        }
    }

    public static void checkViewHardAccelerate(View view) {
        /**
         * 锤子手机 小米2手机 关闭硬件加速 否则在线路详情页 给路况设置透明度会突然消失
         */
        /**
         * 华为手机站点点击
         */
        view.setLayerType(View.LAYER_TYPE_SOFTWARE, null);
    }

    /**
     * 关闭低版本硬件加速
     * <p>
     * https://developer.android.com/guide/topics/graphics/hardware-accel.html#unsupported
     */
//    public static void closeLowLevelHardAccelerate(View view) {
//        if (Build.VERSION.SDK_INT < VERSION_CODES.LOLLIPOP) {
//            view.setLayerType(View.LAYER_TYPE_SOFTWARE, null);
//        }
//    }

    private static final String CHANNEL_VIVO = "app_vivo_store";

    //vivo渠道屏蔽添加收藏到桌面功能
    public static boolean enableFavShortcut(Context context) {
        return !CHANNEL_VIVO.equals(getAppMetaData(context));
    }

    /**
     * 获取application中指定的meta-data
     *
     * @return 如果没有获取成功(没有对应值, 或者异常)，则返回值为空
     */
    public static String getAppMetaData(Context ctx) {
        if (ctx == null) {
            return null;
        }
//        String resultData = WalleChannelReader.getChannel(ctx.getApplicationContext());
        return "";
    }


    public static Map<String, String> getSignInfo(Context context) {
        Map map = new HashMap();
        try {
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), PackageManager.GET_SIGNATURES);
            Signature[] signs = packageInfo.signatures;
            Signature sign = signs[0];
            String md5 = getSignatureString(sign, "MD5");
            map.put("md5", md5);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return map;
    }

    public static String getSignatureString(Signature sig, String type) {
        byte[] hexBytes = sig.toByteArray();
        String fingerprint = "error!";
        try {
            MessageDigest digest = MessageDigest.getInstance(type);
            if (digest != null) {
                byte[] digestBytes = digest.digest(hexBytes);
                StringBuilder sb = new StringBuilder();
                for (byte digestByte : digestBytes) {
                    sb.append((Integer.toHexString((digestByte & 0xFF) | 0x100)).substring(1, 3));
                }
                fingerprint = sb.toString();
            }
        } catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        return fingerprint;
    }

    private static List<ApplicationInfo> installApplications;
    private static boolean hasGetInstallApplications;

    public static List<ApplicationInfo> getInstalledApplications(PackageManager packageManager) {
        if (!hasGetInstallApplications) {
            installApplications = packageManager.getInstalledApplications(0);
            hasGetInstallApplications = true;
        }
        return null != installApplications ? installApplications : new ArrayList<>();
    }

    /**
     * @return 当前进程名
     */
    public static String getCurrentProcessName(Context context) {
        //1)通过Application的API获取当前进程名
        String currentProcessName = getCurrentProcessNameByApplication();
        if (!TextUtils.isEmpty(currentProcessName)) {
            return currentProcessName;
        }
        //2)通过反射ActivityThread获取当前进程名
        currentProcessName = getCurrentProcessNameByActivityThread();
        if (!TextUtils.isEmpty(currentProcessName)) {
            return currentProcessName;
        }
        //3)通过ActivityManager获取当前进程名
        currentProcessName = getCurrentProcessNameByActivityManager(context);
        return currentProcessName;
    }


    /**
     * 通过Application新的API获取进程名，无需反射，无需IPC，效率最高。
     */
    private static String getCurrentProcessNameByApplication() {
        if (Build.VERSION.SDK_INT >= VERSION_CODES.P) {
            return Application.getProcessName();
        }
        return null;
    }

    /**
     * 通过反射ActivityThread获取进程名，避免了ipc
     */
    private static String getCurrentProcessNameByActivityThread() {
        String processName = null;
        try {
            final Method declaredMethod = Class.forName("android.app.ActivityThread", false, Application.class.getClassLoader())
                    .getDeclaredMethod("currentProcessName", (Class<?>[]) new Class[0]);
            declaredMethod.setAccessible(true);
            final Object invoke = declaredMethod.invoke(null, new Object[0]);
            if (invoke instanceof String) {
                processName = (String) invoke;
            }
        } catch (Throwable e) {
            e.printStackTrace();
        }
        return processName;
    }

    /**
     * 通过ActivityManager 获取进程名，需要IPC通信
     */
    private static String getCurrentProcessNameByActivityManager(Context context) {
        if (context == null) {
            return null;
        }
        int pid = Process.myPid();
        ActivityManager am = (ActivityManager) context.getSystemService(Context.ACTIVITY_SERVICE);
        if (am != null) {
            List<ActivityManager.RunningAppProcessInfo> runningAppList = am.getRunningAppProcesses();
            if (runningAppList != null) {
                for (ActivityManager.RunningAppProcessInfo processInfo : runningAppList) {
                    if (processInfo.pid == pid) {
                        return processInfo.processName;
                    }
                }
            }
        }
        return null;
    }
}
