package com.cqyh.cqadsdkdemo;

import android.Manifest;
import android.annotation.TargetApi;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;

import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatActivity;

import com.cqyh.cqadsdk.AdError;
import com.cqyh.cqadsdk.CQAdSDKAdLoadStrategy;
import com.cqyh.cqadsdk.CQAdSDKConfig;
import com.cqyh.cqadsdk.CQAdSlot;
import com.cqyh.cqadsdk.splash.CQAdSDKSplashAdListener;
import com.cqyh.cqadsdk.splash.CQSplashAd;

import java.util.ArrayList;
import java.util.List;

public class SplashAdActivity extends AppCompatActivity {

    public static final String TAG = SplashAdActivity.class.getSimpleName();
    private CQSplashAd mSplashAd;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        View decorView = getWindow().getDecorView();
        // Hide the status bar.
        int uiOptions = View.SYSTEM_UI_FLAG_FULLSCREEN;
        decorView.setSystemUiVisibility(uiOptions);
        setContentView(R.layout.activity_splash);

        if (Build.VERSION.SDK_INT >= 23) {
            checkAndRequestPermission();
        } else {
            fetchSplashAd();
        }
    }

    /**
     * ----------非常重要----------
     * <p>
     * Android6.0以上的权限适配简单示例：
     * <p>
     * 如果targetSDKVersion >= 23，那么建议动态申请相关权限，再调用优量汇SDK
     * <p>
     * SDK不强制校验下列权限（即:无下面权限sdk也可正常工作），但建议开发者申请下面权限，尤其是READ_PHONE_STATE权限
     * <p>
     * READ_PHONE_STATE权限用于允许SDK获取用户标识,
     * 针对单媒体的用户，允许获取权限的，投放定向广告；不允许获取权限的用户，投放通投广告，媒体可以选择是否把用户标识数据提供给优量汇，并承担相应广告填充和eCPM单价下降损失的结果。
     * <p>
     * Demo代码里是一个基本的权限申请示例，请开发者根据自己的场景合理地编写这部分代码来实现权限申请。
     * 注意：下面的`checkSelfPermission`和`requestPermissions`方法都是在Android6.0的SDK中增加的API，如果您的App还没有适配到Android6.0以上，则不需要调用这些方法，直接调用优量汇SDK即可。
     */
    @TargetApi(Build.VERSION_CODES.M)
    private void checkAndRequestPermission() {
        List<String> lackedPermission = new ArrayList<String>();
        if (!(checkSelfPermission(android.Manifest.permission.READ_PHONE_STATE) == PackageManager.PERMISSION_GRANTED)) {
            lackedPermission.add(android.Manifest.permission.READ_PHONE_STATE);
        }

        if (!(checkSelfPermission(android.Manifest.permission.ACCESS_FINE_LOCATION) == PackageManager.PERMISSION_GRANTED)) {
            lackedPermission.add(android.Manifest.permission.ACCESS_FINE_LOCATION);
        }

        if (!(checkSelfPermission(android.Manifest.permission.WRITE_EXTERNAL_STORAGE) == PackageManager.PERMISSION_GRANTED)) {
            lackedPermission.add(Manifest.permission.WRITE_EXTERNAL_STORAGE);
        }

        // 如果需要的权限都已经有了，那么直接调用SDK
        if (lackedPermission.size() == 0) {
            fetchSplashAd();
        } else {
            // 建议请求所缺少的权限，在onRequestPermissionsResult中再看是否获得权限
            String[] requestPermissions = new String[lackedPermission.size()];
            lackedPermission.toArray(requestPermissions);
            requestPermissions(requestPermissions, 1024);
        }
    }

    private boolean hasAllPermissionsGranted(int[] grantResults) {
        for (int grantResult : grantResults) {
            if (grantResult == PackageManager.PERMISSION_DENIED) {
                return false;
            }
        }
        return true;
    }

    @Override
    public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        if (requestCode == 1024 && hasAllPermissionsGranted(grantResults)) {
            Log.e(TAG, "splashAd onRequestPermissionsResult success ");
            fetchSplashAd();
        } else {
//            Toast.makeText(this, "应用缺少必要的权限！请点击\"权限\"，打开所需要的权限。", Toast.LENGTH_LONG).show();
//            Intent intent = new Intent(Settings.ACTION_APPLICATION_DETAILS_SETTINGS);
//            intent.setData(Uri.parse("package:" + getPackageName()));
//            startActivity(intent);
//            finish();
            Log.e(TAG, "splashAd onRequestPermissionsResult failed");
            fetchSplashAd();
        }
    }

    /**
     * 打开主页
     */
    private void openMainActivity() {
        if (!isFinishing()) {
            startActivity(new Intent(this, MainActivity.class));
            finish();
        }
    }

    private boolean isAdClosed;//切到后台可能无法打开MainActivity
    private boolean isPaused;//点击广告后，如何打开落地页，禁止onAdClose打开MainActivity

    @Override
    protected void onResume() {
        super.onResume();
        if (isAdClosed && isPaused) {
            openMainActivity();
        }
        isPaused = false;
    }

    @Override
    protected void onPause() {
        super.onPause();
        isPaused = true;
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        if (mSplashAd != null) {
            mSplashAd.destroy();
        }
    }

    /**
     * 请求开屏广告
     */
    private void fetchSplashAd() {
        ViewGroup adContainer = findViewById(R.id.cll_splash_container);
        CQAdSlot cllAdSlot = new CQAdSlot.Builder()
                .setPlacementId(CqConstant.PLACEMENT_ID_SPLASH)
                .setImageAcceptedSize(1080, 1920)
                .build();
        new CQAdSDKAdLoadStrategy().fetchSplashAd(this, cllAdSlot, 5_000, new CQAdSDKSplashAdListener() {
            @Override
            public void onAdLoadSuccess(CQSplashAd splashAd) {
                mSplashAd = splashAd;
                splashAd.show(adContainer);
                Log.e(CQAdSDKConfig.class.getSimpleName(), " splash  onAdLoadSuccess and sdkName is  " + mSplashAd.getAdName());
            }

            @Override
            public void onAdLoadFailed(AdError adError) {
                openMainActivity();
                Log.e(CQAdSDKConfig.class.getSimpleName(), "splashAd onAdLoadFailed errorCode == " + adError.getCode() +
                        " errorMsg == " + adError.getMsg());
            }

            @Override
            public void onAdClicked() {
                isAdClosed = true;
                Log.e(TAG, "splashAd onAdClicked ");
                if (mSplashAd.getExtraInfo() != null) {
                    String json = (String) mSplashAd.getExtraInfo().get("extraJson");
                    Log.e(TAG, "splashAd onAdClicked  and extraJson == " + json);
                }
            }

            @Override
            public void onAdExpose() {
                Log.e(TAG, "splashAd onAdExpose ");
            }

            @Override
            public void onAdSkip() {
                isAdClosed = true;
                if (isPaused) {
                    return;
                }
                openMainActivity();
                Log.e(TAG, " splashAd onAdSkip ");
            }

            @Override
            public void onTimeReached() {
                isAdClosed = true;
                adContainer.removeAllViews();
                if (isPaused) {
                    return;
                }
                openMainActivity();
                Log.e(TAG, "splashAd onTimeReached ");
            }
        });
    }
}
