package com.cqyh.cqadsdkdemo;

import android.app.Application;
import android.content.Context;
import android.util.Log;

import androidx.multidex.MultiDex;

import com.cqyh.cqadsdk.CQAdSDKConfig;
import com.cqyh.cqadsdk.CQAdSDKManager;


public class MyApplication extends Application {

    @Override
    protected void attachBaseContext(Context base) {
        super.attachBaseContext(base);
        MultiDex.install(this);
    }

    @Override
    public void onCreate() {
        super.onCreate();
        CrashLogger.register(this);
        String appProcessName = SystemUtil.getCurrentProcessName(this);
        Log.e("cllAdSdk", " currentProcessName == " + appProcessName);
        if (getPackageName().equals(appProcessName)) {
            boolean agreePrivacy = LessPreference.getInstance(this).getBoolean(CqConstant.KEY_AGREE_PRIVACY, true);
            CQAdSDKConfig sdkConfig = new CQAdSDKConfig.Builder()
                    .setAppId("300087")
                    .setDebug(true)
                    .setChannel("vivo")
                    .setAgreePersonalStrategy(agreePrivacy)
                    .setDeviceId("")
                    .build();

            CQAdSDKManager.getInstance().initConfig(this, sdkConfig);
        }
    }
}
