package com.cqyh.cqadsdkdemo;

import android.app.AlertDialog;
import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.widget.Button;
import android.widget.TextView;

import androidx.appcompat.app.AppCompatActivity;

import com.cqyh.cqadsdk.AdError;
import com.cqyh.cqadsdk.CQAdSDKAdLoadStrategy;
import com.cqyh.cqadsdk.game.OpenCallBack;

import java.util.HashMap;
import java.util.Map;

public class MainActivity extends AppCompatActivity {

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);
        boolean agreePrivacy = LessPreference.getInstance(this).getBoolean(CqConstant.KEY_AGREE_PRIVACY, true);
        Button button = findViewById(R.id.cll_privacy);
        button.setText(agreePrivacy ? getString(R.string.close_privacy) : getString(R.string.open_privacy));
        
        // 显示隐私协议弹窗
        showPrivacyDialog();
    }

    /**
     * 显示隐私协议弹窗
     */
    private void showPrivacyDialog() {
        AlertDialog.Builder builder = new AlertDialog.Builder(this);
        builder.setTitle("隐私政策");
        
        // 使用自定义布局
        View dialogView = getLayoutInflater().inflate(R.layout.dialog_privacy_policy, null);
        
        // 获取中间的 TextView 并设置可点击的链接
        TextView contentTextView = dialogView.findViewById(R.id.tv_privacy_content);
        setupClickableLinks(contentTextView);
        
        builder.setView(dialogView);
        builder.setCancelable(false);
        builder.setPositiveButton("同意并继续", (dialog, which) -> {
            dialog.dismiss();
            // 可以在这里记录用户同意隐私政策
            Log.d("MainActivity", "用户同意隐私政策");
        });
        
        builder.setNegativeButton("不同意", (dialog, which) -> {
            dialog.dismiss();
            // 用户不同意，可以选择退出应用或限制功能
            Log.d("MainActivity", "用户不同意隐私政策");
            // 如果需要强制同意，可以在这里调用 finish() 退出应用
            finish();
        });
        
        AlertDialog dialog = builder.create();
        dialog.show();
    }

    /**
     * 设置可点击的链接
     */
    private void setupClickableLinks(TextView textView) {
        String fullText = "感谢您对于元气SDK的信赖，在使用前您请务必阅读并同意《隐私政策》及《第三方共享清单》，我们将按照政策和协议内容为您提供服务。";
        
        // 创建 SpannableString 来支持部分文本的点击
        android.text.SpannableString spannableString = new android.text.SpannableString(fullText);
        
        // 设置《隐私政策》的点击效果
        int privacyStart = fullText.indexOf("《隐私政策》");
        int privacyEnd = privacyStart + "《隐私政策》".length();
        if (privacyStart != -1) {
            spannableString.setSpan(
                new android.text.style.ForegroundColorSpan(0xFF2196F3), // 蓝色
                privacyStart, privacyEnd, 
                android.text.Spannable.SPAN_EXCLUSIVE_EXCLUSIVE
            );
            spannableString.setSpan(
                new android.text.style.UnderlineSpan(),
                privacyStart, privacyEnd,
                android.text.Spannable.SPAN_EXCLUSIVE_EXCLUSIVE
            );
        }
        
        // 设置《第三方共享清单》的点击效果
        int thirdPartyStart = fullText.indexOf("《第三方共享清单》");
        int thirdPartyEnd = thirdPartyStart + "《第三方共享清单》".length();
        if (thirdPartyStart != -1) {
            spannableString.setSpan(
                new android.text.style.ForegroundColorSpan(0xFF2196F3), // 蓝色
                thirdPartyStart, thirdPartyEnd,
                android.text.Spannable.SPAN_EXCLUSIVE_EXCLUSIVE
            );
            spannableString.setSpan(
                new android.text.style.UnderlineSpan(),
                thirdPartyStart, thirdPartyEnd,
                android.text.Spannable.SPAN_EXCLUSIVE_EXCLUSIVE
            );
        }
        
        textView.setText(spannableString);
        textView.setMovementMethod(android.text.method.LinkMovementMethod.getInstance());
        
        // 使用触摸事件来检测点击
        textView.setOnTouchListener((v, event) -> {
            if (event.getAction() == android.view.MotionEvent.ACTION_UP) {
                // 获取触摸位置相对于 TextView 的偏移
                int x = (int) event.getX();
                int y = (int) event.getY();
                
                Log.d("MainActivity", "触摸位置: x=" + x + ", y=" + y);
                
                // 获取触摸位置的字符偏移
                android.text.Layout layout = textView.getLayout();
                if (layout != null) {
                    int line = layout.getLineForVertical(y);
                    int offset = layout.getOffsetForHorizontal(line, x);
                    
                    Log.d("MainActivity", "触摸字符偏移: " + offset + ", 隐私政策范围: " + privacyStart + "-" + privacyEnd + ", 第三方清单范围: " + thirdPartyStart + "-" + thirdPartyEnd);
                    
                    // 检查点击的是哪个链接
                    if (offset >= privacyStart && offset < privacyEnd) {
                        // 点击了《隐私政策》
                        Log.d("MainActivity", "检测到隐私政策点击");
                        showPrivacyPolicyDetail();
                        return true;
                    } else if (offset >= thirdPartyStart && offset < thirdPartyEnd) {
                        // 点击了《第三方共享清单》
                        Log.d("MainActivity", "检测到第三方共享清单点击");
                        showThirdPartyListDetail();
                        return true;
                    }
                }
            }
            return false;
        });
    }

    /**
     * 显示隐私政策详情
     */
    private void showPrivacyPolicyDetail() {
        Log.d("MainActivity", "开始显示隐私政策详情");
        Intent intent = new Intent(this, WebActivity.class);
        intent.putExtra(WebActivity.EXTRA_TITLE, "隐私政策");
        intent.putExtra(WebActivity.EXTRA_TYPE, WebActivity.TYPE_URL);
        intent.putExtra(WebActivity.EXTRA_URL, CqConstant.PageLink.URL_PRIVACY_POLICY_SIMPLIFIED);
        Log.d("MainActivity", "隐私政策URL: " + CqConstant.PageLink.URL_PRIVACY_POLICY_SIMPLIFIED);
        startActivity(intent);
    }

    /**
     * 显示第三方共享清单详情
     */
    private void showThirdPartyListDetail() {
        Log.d("MainActivity", "开始显示第三方共享清单详情");
        Intent intent = new Intent(this, WebActivity.class);
        intent.putExtra(WebActivity.EXTRA_TITLE, "第三方共享清单");
        intent.putExtra(WebActivity.EXTRA_TYPE, WebActivity.TYPE_URL);
        
        intent.putExtra(WebActivity.EXTRA_URL, CqConstant.PageLink.URL_PRIVACY_SHARED_LIST);
        startActivity(intent);
    }

    public void fetchSplashAd(View view) {
        startActivity(new Intent(this, SplashAdActivity.class));
    }

    public void fetchInterstitialAd(View view) {
        Intent intent = new Intent(this, InterstitialAdActivity.class);
        startActivity(intent);
    }

    public void fetchExpressAd(View view) {
        Intent intent = new Intent(this, ExpressAdActivity.class);
        startActivity(intent);
    }

    public void handlePrivacy(View view) {
        boolean agreePrivacy = LessPreference.getInstance(this).getBoolean(CqConstant.KEY_AGREE_PRIVACY, true);
        Button button = findViewById(R.id.cll_privacy);
        agreePrivacy = !agreePrivacy;
        button.setText(agreePrivacy ? getString(R.string.close_privacy) : getString(R.string.open_privacy));
        LessPreference.getInstance(this).commit(CqConstant.KEY_AGREE_PRIVACY, agreePrivacy);
    }

    public void fetchNativeAd(View view) {
        Intent intent = new Intent(this, FeedAdActivity.class);
        startActivity(intent);
    }
}