package com.cqyh.cqadsdkdemo;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.SharedPreferences.Editor;

import java.util.Map;

public class LessPreference {

    private static final String NAME = "cll.ad.demo";
    private static LessPreference lessPreference;
    private final SharedPreferences mSP;
    private Editor mEditor;

    private LessPreference(Context context) {
        mSP = context.getSharedPreferences(NAME, Context.MODE_PRIVATE);
        mEditor = mSP.edit();
    }

    public static LessPreference getInstance(Context context) {
        if (lessPreference == null) {
            lessPreference = new LessPreference(context.getApplicationContext());
        }
        return lessPreference;
    }

    public boolean getBoolean(String key, boolean defValue) {
        return mSP.getBoolean(key, defValue);
    }

    public int getInt(String key, int defValue) {
        return mSP.getInt(key, defValue);
    }

    public long getLong(String key, long defValue) {
        return mSP.getLong(key, defValue);
    }

    public float getFloat(String key, float defValue) {
        return mSP.getFloat(key, defValue);
    }

    public String getString(String key, String defValue) {
        return mSP.getString(key, defValue);
    }

    public Map<String, ?> getAll() {
        return mSP.getAll();
    }

    public LessPreference put(String key, Object value) {
        if (value == null) {
            mEditor.putString(key, null);
        } else if (value instanceof Boolean) {
            mEditor.putBoolean(key, (Boolean) value);
        } else if (value instanceof Integer || value instanceof Byte) {
            mEditor.putInt(key, (Integer) value);
        } else if (value instanceof Long) {
            mEditor.putLong(key, (Long) value);
        } else if (value instanceof Float) {
            mEditor.putFloat(key, (Float) value);
        } else if (value instanceof String) {
            mEditor.putString(key, (String) value);
        } else {
            //值不是Boolean, Integer, Byte, Long, Float, String的类型之一，将调用它的toString()进行保存
            mEditor.putString(key, value.toString());
        }
        return this;
    }

    public boolean commit(String key, Object value) {
        return put(key, value).commit();
    }

    public boolean commit() {
        boolean commit = mEditor.commit();
        mEditor = mSP.edit();
        return commit;
    }

    public LessPreference remove(String key) {
        mEditor.remove(key);
        return this;
    }

    public LessPreference clear() {
        mEditor.clear();
        return this;
    }

    public boolean contains(String key) {
        return mSP.contains(key);
    }

}
