package com.cqyh.cqadsdkdemo;

import android.content.Context;
import android.graphics.Bitmap;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.annotation.Nullable;

import com.cqyh.cqadsdk.CQAdConstant;
import com.cqyh.cqadsdk.imageloader.core.ImageLoader;
import com.cqyh.cqadsdk.imageloader.core.assist.FailReason;
import com.cqyh.cqadsdk.imageloader.core.listener.ImageLoadingListener;
import com.cqyh.cqadsdk.nativeAd.CQNativeAd;
import com.cqyh.cqadsdk.nativeAd.CQViewBinder;
import com.cqyh.cqadsdk.nativeAd.widget.CQMediaView;

/**
 * 对标202
 */
public class LeftSmallPicAdView extends FrameLayout {

    private LinearLayout vLeftSmallPictureContainer;
    private TextView vLeftSmallPictureDesc;
    private TextView vLeftSmallPictureTitle;
    private TextView vLeftSmallPictureTip;
    private ImageView vLeftSmallPicture;
    private TextView vLeftSmallPictureIcon;
    private CQMediaView vLeftSmallPictureMedia;
    private ImageView vLineLeftSmallAdClose;
    private ImageView vLeftSmallPicLogo;

    public LeftSmallPicAdView(Context context) {
        this(context, null);
    }

    public LeftSmallPicAdView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, -1);
    }

    public LeftSmallPicAdView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        LayoutInflater.from(context).inflate(R.layout.cq_include_left_small_pic, this);
    }

    public void showAd(CQNativeAd cqNativeAd) {
        if (vLeftSmallPictureContainer == null) {
            vLeftSmallPictureContainer = findViewById(R.id.cll_ad_line_bottom_left_small_picture);
            vLeftSmallPictureDesc = findViewById(R.id.cll_line_bottom_left_small_picture_desc);
            vLeftSmallPictureTitle = findViewById(R.id.cll_line_bottom_left_small_picture_title);
            vLeftSmallPictureTip = findViewById(R.id.cll_line_bottom_left_small_picture_icon);
            vLeftSmallPicture = findViewById(R.id.cll_line_bottom_left_small_picture);
            vLeftSmallPictureIcon = findViewById(R.id.cll_line_bottom_left_small_picture_icon);
            vLineLeftSmallAdClose = findViewById(R.id.cll_line_left_small_ad_close);
            vLeftSmallPicLogo = findViewById(R.id.cll_line_bottom_left_ad_logo);
            vLeftSmallPictureMedia = findViewById(R.id.cll_line_bottom_left_small_gdt_media_view);
        }

        int imageWidth = (DeviceUtil.getScreenWidth(getContext()) - DeviceUtil.dp2px(getContext(), 24)) / 2;
        int imageHeight = DeviceUtil.getImageHeightFromWidth(imageWidth);

        MarginLayoutParams layoutParams = (MarginLayoutParams) vLeftSmallPictureContainer.getLayoutParams();
        layoutParams.height = imageHeight;
        vLeftSmallPictureContainer.setLayoutParams(layoutParams);

        LayoutParams layoutParams1 = (LayoutParams) vLeftSmallPicture.getLayoutParams();
        layoutParams1.width = imageWidth;
        layoutParams1.height = imageHeight;
        vLeftSmallPicture.setLayoutParams(layoutParams1);

        ViewGroup.LayoutParams layoutParams2 = vLeftSmallPictureMedia.getLayoutParams();
        layoutParams2.width = imageWidth;
        layoutParams2.height = imageHeight;

        if (cqNativeAd.getAdImageMode() == CQAdConstant.IMAGE_MODE_VIDEO) {
            vLeftSmallPicture.setVisibility(GONE);
            vLeftSmallPictureMedia.setVisibility(VISIBLE);
        } else {
            vLeftSmallPicture.setVisibility(VISIBLE);
            vLeftSmallPictureMedia.setVisibility(GONE);

            ImageLoader.getInstance().displayImage(cqNativeAd.getImageUrl(), vLeftSmallPicture);
        }

        vLeftSmallPictureDesc.setText(cqNativeAd.getDescription());
        vLeftSmallPictureTitle.setText(cqNativeAd.getTitle());
        vLeftSmallPictureIcon.setVisibility(VISIBLE);

        vLeftSmallPictureTip.setText("广告");

        vLeftSmallPicLogo.setVisibility(VISIBLE);
        Log.e("fanss", " adlogo == " + cqNativeAd.getAdLogoUrl());
        if (!TextUtils.isEmpty(cqNativeAd.getAdLogoUrl())) {
            ImageLoader.getInstance().loadImage(cqNativeAd.getAdLogoUrl(), new ImageLoadingListener() {
                @Override
                public void onLoadingStarted(String imageUri, View view) {

                }

                @Override
                public void onLoadingFailed(String imageUri, View view, FailReason failReason) {

                }

                @Override
                public void onLoadingComplete(String imageUri, View view, Bitmap loadedImage) {
                    vLeftSmallPicLogo.setImageBitmap(loadedImage);
                }

                @Override
                public void onLoadingCancelled(String imageUri, View view) {

                }
            });
        }

        vLineLeftSmallAdClose.setOnClickListener(new OnClickListener() {
            @Override
            public void onClick(View v) {
                if (getParent() != null) {
                    ((ViewGroup) getParent()).removeView(LeftSmallPicAdView.this);
                }
            }
        });
    }

    public CQViewBinder getViewBinder() {
        return new CQViewBinder.Builder(R.layout.cq_include_left_small_pic)
                .mediaViewIdId(R.id.cll_line_bottom_left_small_gdt_media_view)
                .mainImageId(R.id.cll_line_bottom_left_small_picture)
                .descriptionTextId(R.id.cll_line_bottom_left_small_picture_desc)
                .titleId(R.id.cll_line_bottom_left_small_picture_title)
                .build();
    }
}
