package com.cqyh.cqadsdkdemo;

import static com.cqyh.cqadsdkdemo.SplashAdActivity.TAG;

import android.os.Build;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Toast;

import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatActivity;

import com.cqyh.cqadsdk.AdError;
import com.cqyh.cqadsdk.CQAdSDKAdLoadStrategy;
import com.cqyh.cqadsdk.interstitial.CQAdSDKInterstitialAdListener;
import com.cqyh.cqadsdk.interstitial.CQInterstitialAd;


public class InterstitialAdActivity extends AppCompatActivity {


    private CQInterstitialAd mCllInterstitialAd;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_interstitial);
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        if (mCllInterstitialAd != null) {
            mCllInterstitialAd.destroy();
        }
    }

    public void fetchInterstitialAd(View view) {
        ViewGroup adContainer = findViewById(R.id.cll_interstitial_container);
        new CQAdSDKAdLoadStrategy().fetchInterstitialAd(this, CqConstant.PLACEMENT_ID_INTERSTITIAL, new CQAdSDKInterstitialAdListener() {

            @Override
            public void onAdLoadSuccess(CQInterstitialAd interstitialAd) {
                mCllInterstitialAd = interstitialAd;
                interstitialAd.show();
                Toast.makeText(InterstitialAdActivity.this, "插屏广告返回成功", Toast.LENGTH_LONG).show();
            }

            @Override
            public void onAdLoadFailed(AdError adError) {
                Log.e(TAG, "interstitialAd onAdLoadFailed ");
                Toast.makeText(InterstitialAdActivity.this, "插屏广告返回失败", Toast.LENGTH_LONG).show();
            }

            @Override
            public void onAdClicked() {
                Log.e(TAG, "interstitialAd onAdClicked ");
                Toast.makeText(InterstitialAdActivity.this, "插屏广告点击", Toast.LENGTH_LONG).show();
            }

            @Override
            public void onAdExpose() {
                Log.e(TAG, "interstitialAd onAdExpose ");
                Toast.makeText(InterstitialAdActivity.this, "插屏广告展示", Toast.LENGTH_LONG).show();
            }

            @Override
            public void onAdClose() {
                adContainer.removeAllViews();
                Toast.makeText(InterstitialAdActivity.this, "插屏广告关闭", Toast.LENGTH_LONG).show();
                Log.e(TAG, "interstitialAd onAdClose ");
            }
        });
    }
}
