package com.cqyh.cqadsdkdemo;

import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;

import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatActivity;

import com.cqyh.cqadsdk.AdError;
import com.cqyh.cqadsdk.CQAdSDKAdLoadStrategy;
import com.cqyh.cqadsdk.nativeAd.CQAdOptionUtil;
import com.cqyh.cqadsdk.nativeAd.CQAdSDKNativeAdListener;
import com.cqyh.cqadsdk.nativeAd.CQAdSlotBaiduOption;
import com.cqyh.cqadsdk.nativeAd.CQAdSlotGDTOption;
import com.cqyh.cqadsdk.nativeAd.CQNativeAd;
import com.cqyh.cqadsdk.nativeAd.CQNativeAdListener;
import com.cqyh.cqadsdk.nativeAd.CQNativeAdSlot;
import com.cqyh.cqadsdk.nativeAd.widget.CQNativeAdView;

import java.util.ArrayList;
import java.util.List;

public class FeedAdActivity extends AppCompatActivity {

    private static final String TAG = FeedAdActivity.class.getSimpleName();
    private CQNativeAd mCQNativeAd;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_feed);
    }

    @Override
    protected void onResume() {
        super.onResume();
        if (mCQNativeAd != null) {
            mCQNativeAd.resume();
        }
    }

    @Override
    protected void onPause() {
        super.onPause();
        if (mCQNativeAd != null) {
            mCQNativeAd.onPause();
        }
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        if (mCQNativeAd != null) {
            mCQNativeAd.destroy();
        }
    }

    public void fetchNativeAd(View view) {
        CQNativeAdView adContainer = findViewById(R.id.cll_native_ad_container);
        LeftSmallPicAdView adView = new LeftSmallPicAdView(this);
        CQNativeAdSlot cqNativeAdSlot = new CQNativeAdSlot.Builder()
                .setCQAdSlotBaiduOption(CQAdOptionUtil.getCQAdSlotBaiduOption().build())
                .setCQAdSlotGDTOption(CQAdOptionUtil.getCQAdSlotGDTOption().build())
                .setMuted(true)
                .setLoadCount(1)
                .build();

        new CQAdSDKAdLoadStrategy().fetchNativeAd(this, CqConstant.PLACEMENT_ID_NATIVE_AD, cqNativeAdSlot, new CQAdSDKNativeAdListener() {
            @Override
            public void onAdLoadSuccess(List<CQNativeAd> nativeAdList) {
                if (nativeAdList == null || nativeAdList.isEmpty()) {
                    Log.e("fanss", " native Ad list is empty !!!");
                    return;
                }
                adContainer.setVisibility(View.VISIBLE);
                adContainer.addView(adView, new ViewGroup.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT));
                mCQNativeAd = nativeAdList.get(0);
                adView.showAd(mCQNativeAd);
                List<View> clickView = new ArrayList<>();
                clickView.add(adContainer);
                clickView.add(adView);
                mCQNativeAd.setNativeAdListener(new CQNativeAdListener() {
                    @Override
                    public void onAdClick() {
                        Log.e(TAG, " native ad is onAdClick");
                    }

                    @Override
                    public void onAdShow() {
                        Log.e(TAG, " native ad is onAdShow");
                    }
                });
                //CQViewBinder 是必须类,需要开发者在确定好View之后把Id设置给CQViewBinder类，并在注册事件时传递给SDK
                mCQNativeAd.registerView(adContainer, clickView, clickView, adView.getViewBinder());
            }

            @Override
            public void onAdLoadFailed(AdError adError) {
                Log.e(TAG, " errorCode == " + adError.getCode() + " errorMsg ==  " + adError.getMsg());
            }
        });
    }

    private static CQAdSlotBaiduOption.Builder getCQAdSlotBaiduOption() {
        return new CQAdSlotBaiduOption.Builder()
                .setDownloadAppConfirmPolicy(CQAdSlotBaiduOption.DOWNLOAD_APP_CONFIRM_ALWAYS)//设置下载提示弹框的展示规则, 默认不提示，注意在load()方法前调用
                .setUseRewardCountdown(true) // 设置是否展示奖励领取倒计时提示
                .setCacheVideoOnlyWifi(true);
    }

    private static CQAdSlotGDTOption.Builder getCQAdSlotGDTOption() {
        return new CQAdSlotGDTOption.Builder()
                .setGDTAutoPlayMuted(true)//自动播放是否静音，默认true
                .setGDTDetailPageMuted(false)//详情页是否静音，默认值为false，即有声播放；
                .setGDTEnableDetailPage(true)//是否能跳转详情页，默认true
                .setGDTEnableUserControl(false)//是否能控制是否暂停与播放，默认false
                .setGDTMaxVideoDuration(0)//视频最大长度，单位:秒 此设置会影响广告填充，请谨慎设置
                .setGDTMinVideoDuration(0)//视频最小长度，单位:秒 此设置会影响广告填充，请谨慎设置
                .setNeedProgressBar(true)//设置视频广告在在预览页播放过程中是否显示进度条，默认为true，显示进度条；只对自渲染视频广告生效
                .setNeedCoverImage(true)//设置视频广告在预览页未开始播放时是否显示封面图，默认为true，显示封面图；只对自渲染视频广告生效
                // CQAdSlotGDTOption.AutoPlayPolicy.WIFI表示只在WiFi下自动播放；
                // CQAdSlotGDTOption.AutoPlayPolicy.ALWAYS表示始终自动播放，不区分当前网络；
                // CQAdSlotGDTOption.AutoPlayPolicy.NEVER表示始终都不自动播放，不区分当前网络，但在WiFi时会预下载视频资源；
                // 默认为始终自动播放；
                .setAutoPlayPolicy(CQAdSlotGDTOption.AutoPlayPolicy.WIFI)//自动播放策略--
                .setDownAPPConfirmPolicy(CQAdSlotGDTOption.DownAPPConfirmPolicy.TYPE_DEFAULT);
        //指定点击 APP 广告后是否展示二次确认，可选项包括 Default（wifi 不展示，非wifi 展示），NoConfirm（所有情况不展示）
    }
}
