package com.cqyh.cqadsdkdemo;

import static com.cqyh.cqadsdkdemo.SplashAdActivity.TAG;

import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Toast;

import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatActivity;

import com.cqyh.cqadsdk.AdError;
import com.cqyh.cqadsdk.CQAdSDKAdLoadStrategy;
import com.cqyh.cqadsdk.express.CQAdSDKExpressAdListener;
import com.cqyh.cqadsdk.express.CQExpressAd;

import java.util.List;

public class ExpressAdActivity extends AppCompatActivity {


    private CQExpressAd mCQExpressAd;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_express);
    }

    @Override
    protected void onResume() {
        super.onResume();
        if (mCQExpressAd != null) {
            mCQExpressAd.resume();
        }
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        if (mCQExpressAd != null) {
            mCQExpressAd.destroy();
        }
    }

    public void fetchExpressAd(View view) {
        ViewGroup adContainer = findViewById(R.id.cll_express_container);
        new CQAdSDKAdLoadStrategy().fetchExpressAd(this, CqConstant.PLACEMENT_ID_EXPRESS, 1, 0, 0, new CQAdSDKExpressAdListener() {

            @Override
            public void onAdLoadSuccess(List<CQExpressAd> list) {
                if (list == null || list.isEmpty()) {
                    return;
                }
                mCQExpressAd = list.get(0);
                mCQExpressAd.show(adContainer);
                Toast.makeText(ExpressAdActivity.this, "模版信息流广告返回", Toast.LENGTH_LONG).show();
            }

            @Override
            public void onAdLoadFailed(AdError adError) {
                Log.e(TAG, " expressAd  onAdLoadFailed " + adError.getCode() + adError.getMsg());
                Toast.makeText(ExpressAdActivity.this, "模版信息流广告返回失败", Toast.LENGTH_LONG).show();
            }

            @Override
            public void onAdClicked() {
                Log.e(TAG, "expressAd onAdClicked ");
                Toast.makeText(ExpressAdActivity.this, "模版信息流广告点击", Toast.LENGTH_LONG).show();
            }

            @Override
            public void onAdExpose() {
                Log.e(TAG, "expressAd onAdExpose ");
                Toast.makeText(ExpressAdActivity.this, "模版信息流广告展示", Toast.LENGTH_LONG).show();
            }

            @Override
            public void onAdClose(CQExpressAd cllExpressAd) {
                adContainer.removeAllViews();
                Log.e(TAG, "expressAd onAdClose ");
                Toast.makeText(ExpressAdActivity.this, "模版信息流广告关闭", Toast.LENGTH_LONG).show();
            }
        });
    }
}
