package com.cqyh.cqadsdkdemo;

import android.content.Context;
import android.content.res.Resources;
import android.util.TypedValue;

public class DeviceUtil {

    public static int getImageHeightFromWidth(int width) {
        return (int) (width / 16.0 * 9);
    }

    public static int getScreenWidth(Context context) {
        return context.getResources().getDisplayMetrics().widthPixels;
    }

    public static int dp2px(Context context, float dip) {
        if (context == null) {
            return 0;
        }
        Resources resources = context.getResources();
        int px = Math.round(
                TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, dip, resources.getDisplayMetrics()));
        return px;
    }


}
