[TOC]

# 聚合广告

SDK接入文档

| 文档版本  | 更新日期       | 更新内容                                           |
|:------|------------|------------------------------------------------|
| 5.9.2 | 2025-04-28 | 修复已知道问题                                |
| 5.9.0 | 2025-04-03 | 修复已知道问题                                |
| 5.8.0 | 2025-03-03 | 修复已知道问题                                |
| 5.7.2 | 2024-12-12 | 升级广告平台SDK，支持新样式                                |
| 5.7.0 | 2024-10-25 | 升级广告平台SDK，支持新样式                                |
| 5.6.0 | 2024-09-29 | 优化流程，修改已知问题                                    |
| 5.4.2 | 2024-06-14 | 支持小游戏
| 5.4.0 | 2024-05-10 | 适配四家广告平台SDK                                    |
| 5.3.2 | 2024-04-11 | 增加埋点，修改线上bug
| 5.3.0 | 2024-04-01 | 增加 京东SDK TanxSdk支持                             |
| 4.8.2 | 2023-08-14 | 修复已知道问题，升级平台SDK，下载六要素支持                        |
| 4.7.0 | 2023-07-07 | 升级平台SDK，替换摇一摇广告宏                               |
| 4.6.0 | 2023-06-15 | 升级平台SDK，修改线上bug                                |
| 4.5.0 | 2023-05-20 | 升级平台SDK，修改线上bug                                |
| 4.4.2 | 2023-05-10 | 开屏、信息流细分错误码、增加API广告返回具体名称。 升级百度、广点通SDK         |
| 4.4.0 | 2023-04-07 | 增加策略接口缓存机制，优化广告返回速度                            |
| 4.0.4 | 2023-02-27 | 升级联盟平台SDK                                      |
| 4.0.2 | 2023-02-24 | 模版信息流新增样式                                      |
| 3.7.0 | 2022-11-20 | 增加策略，提升ecpm，修改已知问题                             |
| 3.6.6 | 2022-11-14 | 修改已知问题                                         |
| 3.6.0 | 2022-09-22 | 升级广告平台SDK，修改已知问题                               |
| 3.5.0 | 2022-08-19 | 升级广告平台SDK，修改已知问题                               |
| 3.4.0 | 2022-07-20 | 升级广告平台SDK，修改已知问题                               |
| 3.3.8 | 2022-07-08 | 修改已知问题                                         |
| 3.3.6 | 2022-07-04 | 修改已知问题                                         |
| 3.3.4 | 2022-06-20 | 修改已知问题                                         |
| 3.3.2 | 2022-06-07 | 修改已知问题                  |
| 3.3.0 | 2022-05-28 | 广告位支持bidding，删除OAID 信通院SDK                     |
| 3.2.0 | 2022-05-13 | 支持自渲染广告                                        |
| 3.1.0 | 2022-05-07 | 增加新样式 处理已知问题                                   |
| 3.0.1 | 2022-04-28 | 处理已知问题                                         |
| 3.0.0 | 2022-04-02 | 优化加载流程  处理已知问题                                 |
| 2.1.0 | 2022-01-07 | 开屏增加新样式，模版信息流增加新样式 开放个性化广告支持开关 升级穿山甲插屏广告等      |
| 1.0.0 | 2021-10-25 | 集成广点通、穿山甲、快手、百度广告四家广告平台，提供开屏、插屏、模版信息流广告获取，展示接口 |

# 0.接入准备

请联系平台方获取：

- SDK
- 聚合 appId
- 聚合 广告位 placementId

# 1.配置

- 在聚合平台申请 appId 相应的广告位id (placementId)
- 需增加依赖

  	    implementation 'androidx.appcompat:appcompat:1.3.1'
        implementation 'pl.droidsonroids.gif:android-gif-drawable:1.2.24'
        implementation 'androidx.recyclerview:recyclerview:+'
        implementation 'com.google.code.gson:gson:2.8.2'
        implementation 'androidx.exifinterface:exifinterface:1.0.0'
        implementation "androidx.legacy:legacy-support-v4:1.0.0"
        implementation "com.google.protobuf:protobuf-lite:3.0.1"
        implementation "com.google.guava:guava:31.0.1-android"
         implementation "com.airbnb.android:lottie:5.2.0"

- aar包导入，请在工程文件根目录下创建一个名为 libs 的子目录，并将 SDK 的 aar 包拷贝到 libs 目录下（需导入）

      depedencies {
          implementation fileTree(include: ['*.jar', '*.aar'], dir: 'libs')
      }
    京东SDK接入方式：
    ```
    在project级别的build.gradle文件中添加Maven的引用 :maven { url 'https://jitpack.io' }
    在主module的build.gradle文件添加SDK依赖  implementation 'com.github.JAD-FE-TEAM.JADYunAndroid:jad_yun_sdk:2.2.16'
    ```
    TanxSdk接入方式：
    ```
    在project级别的build.gradle文件中添加Maven的引用 :maven { url 'https://maven.aliyun.com/repository/public' }
    在主module的build.gradle文件添加SDK依赖,移除冲出类示例，具体需要根据自己项目冲突情况进行移除。
    implementation (group: 'com.tanx', name: 'TanxUISDK', version: '3.0.3'){
       exclude group: 'com.squareup.okhttp3'
    }
    ```

- 接入广点通时，需要在AndroidManifest.xml\<application\>下添加

        <provider
            android:name="com.qq.e.comm.GDTFileProvider"
            android:authorities="${applicationId}.gdt.fileprovider"
            android:exported="false"
            android:grantUriPermissions="true">
            <meta-data
                android:name="android.support.FILE_PROVIDER_PATHS"
                android:resource="@xml/gdt_file_path" />
        </provider>

- 接入穿山甲时，需要在AndroidManifest.xml\<application\>下添加

  	<provider
  	      android:name="com.bytedance.sdk.openadsdk.TTFileProvider"
  	      android:authorities="${applicationId}.TTFileProvider"
  	      android:exported="false"
  	      android:grantUriPermissions="true">
  	      <meta-data
  	          android:name="android.support.FILE_PROVIDER_PATHS"
  	          android:resource="@xml/file_paths" />
  	  </provider>
  	  <provider
  	  android:name="com.bytedance.sdk.openadsdk.multipro.TTMultiProvider"
  	      android:authorities="${applicationId}.TTMultiProvider"
  	      android:exported="false" />

# 2.SDK使用

SDK已包含广点通、快手、穿山甲、百度的初始化工作，只需开启相应平台

## 1.初始化

完成广点通、快手、穿山甲、百度任意初始化后，初始化本SDK，并开启对应的广告平台，至少选择一个：

	CQAdSDKConfig sdkConfig = new CQAdSDKConfig.Builder()
                .setAppId("申请的appId")
                .setDebug(true)//是否开启debug 日志模式
                .setChannel("")//应用渠道号
                .setAgreePersonalStrategy(agreePrivacy)//是否支持广告个性化
                .setDeviceId("")//设置设备id 设置设备id，在初始化是SDK的时候设置。可以是通用的idfa、oaid等，也可以是开发者自定义的设备id
                .build();

    CQAdSDKManager.getInstance().initConfig(this, sdkConfig);

## 2.申请权限

- SDK 要求最低系统版本为API 17 ，对于适配了Android6.0以上(API >= 23)的APP，建议开发者在获得了
  动态权限之后，调用SDK的初始化代码，否则SDK可能受影响。

- **特别说明:** 请求广告数据前，请务必申请IMEI权限，否则会造成下发下载类广告的数据无法正常下发，
  影响广告计费追踪。所以强烈建议媒体在通过SDK请求广告前，先申请获取IMEI权限。

  	<uses-permission android:name="android.permission.INTERNET" />
  	<uses-permission android:name="android.permission.ACCESS_NETWORK_STATE" />
  	<uses-permission android:name="android.permission.READ_PHONE_STATE" />
  	<uses-permission android:name="android.permission.ACCESS_COARSE_LOCATION" />
  	<!-- 可选 -->
  	<uses-permission android:name="android.permission.ACCESS_FINE_LOCATION" /><!--如果需要精确定位的话请加上此权限-->
  	<uses-permission android:name="android.permission.WRITE_EXTERNAL_STORAGE" />
  	<uses-permission android:name="android.permission.READ_EXTERNAL_STORAGE" />
  	<uses-permission android:name="android.permission.ACCESS_WIFI_STATE" />
  	<uses-permission android:name="android.permission.REQUEST_INSTALL_PACKAGES" />
  	<uses-permission android:name="android.permission.GET_TASKS" />
    <uses-permission android:name="android.permission.QUERY_ALL_PACKAGES" />
    <uses-permission android:name="android.permission.ACCESS_NOTIFICATION_POLICY" />

## 3.接口使用

### 1. 开屏

**简介：**
开屏广告以APP启动作为曝光时机，提供5s的可感知广告展示。用户可以点击广告跳转到目标页面；或者点击右上角的“跳过”按钮，跳转到APP内容首页

**适用场景：**
APP启动时，常会使用开屏广告

**接口调用：**

   	CQAdSlot cqAdSlot = new CQAdSlot.Builder()
                .setPlacementId(placementId)//广告位Id
                .setImageAcceptedSize(width, height)//申请广告图片宽、高，单位：px （目前仅穿山甲广告生效）
                .build();
	new CQAdSDKAdLoadStrategy().fetchSplashAd(Activity, cqAdSlot, time, CQAdSDKSplashAdListener);

| 参数                      | 参数介绍                         |
|:------------------------|------------------------------|
| Context                 | Android的Context，一般传入Activity |
| CQAdSlot                | 申请广告需要的参数                    |
| long                    | 开屏广告请求超时时间                   |
| CQAdSDKSplashAdListener | 广告加载回调                       |

- 详细CQAdSDKSplashAdListener : 广告加载过程的回调接口

| 方法名                         | 方法介绍                 |
|:----------------------------|----------------------|
| onAdLoadFailed(AdError)     | 加载广告错误回调             |
| onAdClicked                 | 点击广告回调               |
| onAdSkip                    | 用户点击跳过按钮             |
| onAdExpose                  | 广告展示回调               |
| onAdLoadSuccess(CQSplashAd) | 广告加载成功回调             |
| onTimeReached               | 开屏广告倒计时结束，此时可以调用跳转方法 |

- 详细CQSplashAd : 广告加载完毕获取ISplashProvider的实例

| 方法名                              | 方法介绍                 |
|:---------------------------------|----------------------|
| void show(ViewGroup adContainer) | 展示开屏广告，参数为开屏广告显示的父容器 |
| destroy()                        | 销毁广告对象               |

- 开屏页与主页在**两个页面**，参考**SplashActivity.java**

### 2. 插屏广告

**简介：**
半屏弹窗广告

**适用场景：**
提供弹窗广告

**接口调用：**

	new CQAdSDKAdLoadStrategy().fetchInterstitialAd(Activity,placementId, CQAdSDKInterstitialAdListener);

| 参数                            | 参数介绍                         |
|:------------------------------|------------------------------|
| Context                       | Android的Context，一般传入Activity |
| String                        | 申请的对应广告位id(placementId)      |
| CQAdSDKInterstitialAdListener | 广告加载回调                       |

- 详细CQAdSDKInterstitialAdListener : 广告加载过程的回调接口

| 方法名                               | 方法介绍     |
|:----------------------------------|----------|
| onAdLoadSuccess(CQInterstitialAd) | 广告加载成功回调 |
| onAdLoadFailed(AdError)           | 加载广告错误回调 |
| onAdClicked()                     | 广告点击回调   |
| onAdExpose()                      | 广告展示回调   |
| onAdClose                         | 广告关闭回调   |

- 详细CQInterstitialAd : 广告加载完毕获取CQInterstitialAd的实例

| 方法名             | 方法介绍             |
|:----------------|------------------|
| show(ViewGroup) | 展示插屏广告；传入展示广告的容器 |
| destroy()       | 销毁广告对象           |

### 3. 模板信息流广告

**简介：**
由平台提供的视频和图文模板广告流

**适用场景：**
有多种模板广告选择，适用不同展示场景，不影响cpm的同时减少接入成本

**接口调用：**

	new CQAdSDKAdLoadStrategy().fetchExpressAd(context, placementId, loadAdCount, expressWidth, expressHeight, CQAdSDKExpressAdListener);

| 参数                       | 参数介绍                         |
|:-------------------------|------------------------------|
| Context                  | Android的Context，一般传入Activity |
| placementId              | 申请的对应广告位id                   |
| loadAdCount              | 请求广告数量                       |
| expressWidth             | 请求模版广告的宽度 单位dp 传0则默认为屏幕宽度    |
| expressHeight            | 请求模版广告的高度 单位dp 传0则默认为自适应高度   |
| CQAdSDKExpressAdListener | 广告加载回调                       |

- 详细CQAdSDKExpressAdListener : 广告加载过程的回调接口

| 方法名                                     | 方法介绍                      |
|:----------------------------------------|---------------------------|
| onAdLoadSuccess(List<CQExpressAd> var1) | 广告加载成功回调                  |
| onAdLoadFailed(AdError var1)            | 加载广告错误回调                  |
| onAdClose(CQExpressAd var1)             | 广告关闭回调，画面解绑广告，调用destroy方法 |
| onAdExpose()                            | 广告曝光回调                    |
| onAdClicked()                           | 广告点击回调                    |

- 详细CQExpressAd : 广告加载完毕获取CQExpressAd的实例

| 方法名                  | 方法介绍           |
|:---------------------|----------------|
| show(ViewGroup var1) | 展示广告，参数为广告的父容器 |
| destroy()            | 销毁广告对象         |

### 4. 自渲染信息流广告

**简介：**
自渲染方式支持开发者自由拼合广告素材，如图片，视频，最大程度的满足展示需求；与原生广告（模板方式）相比，自渲染方式更加自由灵活，开发者可以使用其为开发者的应用打造自定义的布局样式

**适用场景：**
开发者打造自定义的布局样式

**接口调用：**

	new CQAdSDKAdLoadStrategy().fetchNativeAd(Context, placementId, CQNativeAdSlot, CQAdSDKNativeAdListener);

| 参数                      | 参数介绍            |
|:------------------------|-----------------|
| Context                 | Android的Context |
| placementId             | 申请的对应广告位id      |
| CQNativeAdSlot          | 请求广告对应的配置参数     |
| CQAdSDKNativeAdListener | 广告加载回调          |

- 详细CQNativeAdSlot : 广告对应的配置
- 参考代码

  	CQNativeAdSlot cqNativeAdSlot = new CQNativeAdSlot.Builder()
                .setCQAdSlotBaiduOption(CQAdOptionUtil.getCQAdSlotBaiduOption().build())//百度视频广告设置
                .setCQAdSlotGDTOption(CQAdOptionUtil.getCQAdSlotGDTOption().build())//广点通视频广告设置
                .setMuted(true)//是否静音
                .setLoadCount(1)//请求广告数量
                .build();
    布局文件：
     <com.cqyh.cqadsdk.nativeAd.widget.CQNativeAdView
        android:id="@+id/cll_native_ad_container"
        android:layout_width="wrap_content"
        android:layout_height="wrap_content">
        <自定义广告View>
    </com.cqyh.cqadsdk.nativeAd.widget.CQNativeAdView>

- 参考代码

| 方法名                                                             | 方法介绍                           |
|:----------------------------------------------------------------|--------------------------------|
| setMuted(boolean muted)	                                        | 视频是否静音，默认开声音                   |
| setLoadCount(int loadCount)	                                    | Feed广告每次请求返回的广告数量 最多不超过3条，默认是1 |
| setCQAdSlotGDTOption(CQAdSlotGDTOption cqAdSlotGDTOption)       | GDT视频设置                        |
| setCQAdSlotBaiduOption(CQAdSlotBaiduOption cqAdSlotBaiduOption) | 	Baidu音频设置                     |

- CQAdSlotBaiduOption : 百度广告对应的设置
- 参考代码

  	 public static CQAdSlotBaiduOption.Builder getCQAdSlotBaiduOption(){
        return new CQAdSlotBaiduOption.Builder()
                .setDownloadAppConfirmPolicy(CQAdSlotBaiduOption.DOWNLOAD_APP_CONFIRM_ALWAYS)//设置下载提示弹框的展示规则, 默认不提示，注意在load()方法前调用
                .setUseRewardCountdown(true) // 设置是否展示奖励领取倒计时提示
                .setCacheVideoOnlyWifi(true);
   		 }

- CQAdSlotGDTOption : 广点通广告对应的设置

    	public static CQAdSlotGDTOption.Builder getCQAdSlotGDTOption(){
        return new CQAdSlotGDTOption.Builder()
                .setGDTAutoPlayMuted(true)//自动播放是否静音，默认true
                .setGDTDetailPageMuted(false)//详情页是否静音，默认值为false，即有声播放；
                .setGDTEnableDetailPage(true)//是否能跳转详情页，默认true
                .setGDTEnableUserControl(false)//是否能控制是否暂停与播放，默认false
                .setGDTMaxVideoDuration(0)//视频最大长度，单位:秒 此设置会影响广告填充，请谨慎设置
                .setGDTMinVideoDuration(0)//视频最小长度，单位:秒 此设置会影响广告填充，请谨慎设置
                .setNeedProgressBar(true)//设置视频广告在在预览页播放过程中是否显示进度条，默认为true，显示进度条；只对自渲染视频广告生效
                .setNeedCoverImage(true)//设置视频广告在预览页未开始播放时是否显示封面图，默认为true，显示封面图；只对自渲染视频广告生效
                // CQAdSlotGDTOption.AutoPlayPolicy.WIFI表示只在WiFi下自动播放；
                // CQAdSlotGDTOption.AutoPlayPolicy.ALWAYS表示始终自动播放，不区分当前网络；
                // CQAdSlotGDTOption.AutoPlayPolicy.NEVER表示始终都不自动播放，不区分当前网络，但在WiFi时会预下载视频资源；
                // 默认为始终自动播放；
                .setAutoPlayPolicy(CQAdSlotGDTOption.AutoPlayPolicy.WIFI)//自动播放策略--
                .setDownAPPConfirmPolicy(CQAdSlotGDTOption.DownAPPConfirmPolicy.TYPE_DEFAULT);
                //指定点击 APP 广告后是否展示二次确认，可选项包括 Default（wifi 不展示，非wifi 展示），NoConfirm（所有情况不展示）
  }


- 详细CQAdSDKNativeAdListener : 广告加载过程的回调接口

| 方法名                                    | 方法介绍     |
|:---------------------------------------|----------|
| onAdLoadSuccess(List<CQNativeAd> list) | 广告加载成功回调 |
| onAdLoadFailed(AdError adError)        | 加载广告错误回调 |

- 详细CQNativeAd : 广告加载完毕获取CQNativeAd的实例

| 方法名                                                                                                                                | 方法介绍                                                                                      |
|:-----------------------------------------------------------------------------------------------------------------------------------|-------------------------------------------------------------------------------------------|
| String getTitle()                                                                                                                  | 广告标题                                                                                      |
| String getDescription();                                                                                                           | 广告内容描述                                                                                    |
| String getIconUrl();                                                                                                               | 广告Icon                                                                                    |
| String getImageUrl();                                                                                                              | 大图URL                                                                                     |
| int getImageWidth();                                                                                                               | 大图的宽                                                                                      |
| int getImageHeight();                                                                                                              | 大图的高                                                                                      |
| String getActionText();                                                                                                            | 广告按钮文案                                                                                    |
| String getPackageName();                                                                                                           | 下载类型广告包名                                                                                  |
| String getAdLogoUrl();                                                                                                             | 广告logo                                                                                    |
| double getStarRating();                                                                                                            | 广告的下载apk对应的星级                                                                             |
| List<String> getImageList();                                                                                                       | 广告图片列表                                                                                    |
| String getSource();                                                                                                                | 广告来源                                                                                      |
| int getAdImageMode();                                                                                                              | 广告展示类型,大图，小图，组图，视频                                                                        |
| int getInteractionType();                                                                                                          | 广告交互类型                                                                                    |
| int getVideoWidth();                                                                                                               | 返回视频广告宽度                                                                                  |
| int getVideoHeight();                                                                                                              | 返回视频广告高度                                                                                  |
| void setNativeAdListener(CQNativeAdListener var1);                                                                                 | 注册点击回调                                                                                    |
| void setVideoListener(CQVideoListener var1);                                                                                       | 注册视频回调事件                                                                                  |
| void registerView(@NonNull ViewGroup var1, @NonNull List<View> clickViews, @Nullable List<View> creativeViews, CQViewBinder var4); | 注册事件，计费点，参数 clickViews 和 creativeViews 不能只传入广告根布局，还需要添加要响应点击的子布局 ，不然会影响点击效果和影响广告计费        |
| void onPause();                                                                                                                    | 暂停 在activity生命周期onPause中调用                                                                |
| void resume();                                                                                                                     | 恢复  在activity生命周期onResume中调用                                                              |
| void destroy();                                                                                                                    | 释放资源  在activity生命周期onDestroy中调用                                                           |
| CQNativeAdAppInfo getNativeAdAppInfo();                                                                                            | 获取app类广告的app信息，包含应用名称，开发者，版本，apk包大小，隐私政策，权限信息，返回值为CQNativeAdAppInfo数据类型，对于非app类广告返回值为null |

- 详细CQNativeAdListener : 广告行为监听

| 方法名              | 方法介绍  |
|:-----------------|-------|
| void onAdClick() | 广告被点击 |
| void onAdShow()  | 广告展示  |

- 详细CQVideoListener : 视频广告行为监听

| 方法名                                      | 方法介绍     |
|:-----------------------------------------|----------|
| void onVideoStart()                      | 广告视频开始播放 |
| void onVideoPause()                      | 广告视频暂停   |
| void onVideoResume()                     | 广告视频继续播放 |
| void onVideoCompleted()                  | 广告视频播放完成 |
| void onVideoError(@NonNull AdError var1) | 广告视频播放报错 |

### 5. 打开小游戏
**接口调用：**
    new CQAdSDKAdLoadStrategy().openGame(context);

# 3. 混淆

    -keep class com.cqyh.cqadsdk.** {*;}
    -dontwarn com.cqyh.cqadsdk.**
    -keep class tv.cqyh.ijk.** { *; }
    -dontwarn tv.cqyh.ijk.**

    # 穿山甲SDK 混淆规则
    -keep class com.bytedance.sdk.openadsdk.** { *; }
	-keep class com.bytedance.frameworks.** { *; }

	-keep class ms.bd.c.Pgl.**{*;}
	-keep class com.bytedance.mobsec.metasec.ml.**{*;}

	-keep class com.ss.android.**{*;}

	-keep class com.bytedance.embedapplog.** {*;}
	-keep class com.bytedance.embed_dr.** {*;}

	-keep class com.bykv.vk.** {*;}


	# baidu sdk
	-ignorewarnings
	-dontwarn com.baidu.mobads.sdk.api.**
	-keepclassmembers class * extends android.app.Activity {
	   public void *(android.view.View);
	}

	-keepclassmembers enum * {
    public static **[] values();
    public static ** valueOf(java.lang.String);
	}

	-keep class com.baidu.mobads.** { *; }
	-keep class com.style.widget.** {*;}
	-keep class com.component.** {*;}
	-keep class com.baidu.ad.magic.flute.** {*;}
	-keep class com.baidu.mobstat.forbes.** {*;}

	#ks 快手 不接入ks sdk可以不引入
	-keep class org.chromium.** {*;}
	-keep class org.chromium.** { *; }
	-keep class aegon.chrome.** { *; }
	-keep class com.kwai.**{ *; }
	-dontwarn com.kwai.**
	-dontwarn com.kwad.**
	-dontwarn com.ksad.**
	-dontwarn aegon.chrome.**

    #京东
    -keep class com.jd.ad.sdk.** { *; }

    #TanX
    -dontwarn com.alibaba.fastjson.**
    -keep class com.alibaba.fastjson.**{*;}
    -keep class com.bumptech.glide.**{*;}
    -keep class com.alimm.tanx.**{*;}
    -keep class tanxu_do.**{*;}
    -keep class com.tanx.**{*;}
    -keep class tanxc_do.**{*;}
    -keep class * implements java.io.Serializable{
     <fields>;
    <methods>;
    }
    
    #华为
    -keep class com.huawei.openalliance.ad.** { *; }
    -keep class com.huawei.hms.ads.** { *; }

# 4.注意事项

如开启了资源混淆，查看各SDK的官网混淆规则，避免SDK的资源被混淆导致广告无法正常展示

# 5.常见错误

Logcat过滤*CQAdSdk* **可以查看更多的日志**
| 错误描述 | 排查方向 |
| :---- | :--- |
|包名不一致|包名使用聚合申请时填写的包名，使用Demo时记得修改build.gradle里的applicationId|
|签名不一致|签名使用聚合申请时填写的签名SHA1|
|unexpected element <queries> found in <manifest>|升级下gradel版本|